%% CIS II Galen Calibration
% Based on: Assignment 2 - Function solveRx; ASBR Fall 2019 by N. Lamaison
% Function solves the for the unknown rotation of the tool-camera
% transformation using the least-squares method

function [Rx] = solveRx(alphas, betas)

% Finding number of unique configurations used for calibration
N = size(alphas,2);

% Solving Park and Martin method for N == 3 (last columns of alphas and betas will be zero, so
% we replace it with the cross product of columns 1 and 2)
if N == 3
    
    A = [alphas(:,1) alphas(:,2) cross(alphas(:,1), alphas(:,2))];
    B = [betas(:,1) betas(:,2) cross(betas(:,1), betas(:,2))];
    
    % Solving for Rx (N == 3)
    Rx = A /B;
    
% Solving general case (N > 3)
else
    % Defining matrix M
    M = zeros(3);
    
    % Updating matrix M
    for i = 1:N
        M_current = betas(:,i) * alphas(:,i)';
        M = M + M_current;
    end
    [v,d] = eig(transpose(M)*M)
    Rx = v*(d^-0.5)*inv(v)*transpose(M);
    if norm(alphas) == 0 || norm(betas) == 0
        Rx = eye(3);
    end
    %% Solving for Rx (N > 2)
    %Rx = ((M' * M)^-0.5) * M';
    %if det(Rx) ~= 1
        %[U,S,V] = svd(M)

        %V(:,3) = -V(:,3);
        %Rx = V*U';
    %end
end

